<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * vBCms_Widget_Poll
 *
 * @package
 * @author ebrown
 * @copyright Copyright (c) 2009
 * @version $Id: poll.php 32078 2009-09-16 20:39:09Z ebrown $
 * @access public
 */
class vBCms_Widget_Poll extends vBCms_Widget
{
	/*Properties====================================================================*/

	/**
	 * A package identifier.
	 * This is used to resolve any related class names.
	 * It is also used by client code to resolve the class name of this widget.
	 *
	 * @var string
	 */
	protected $package = 'vBCms';

	/**
	 * A class identifier.
	 * This is used to resolve any related class names.
	 * It is also used by client code to resolve the class name of this widget.
	 *
	 * @var string
	 */
	protected $class = 'Poll';

	protected $cache_ttl = 5;

	/*Render========================================================================*/

	/**
	 * Returns the config view for the widget.
	 *
	 * @return vBCms_View_Widget				- The view result
	 */
	public function getConfigView()
	{
		$this->assertWidget();

		vB::$vbulletin->input->clean_array_gpc('r', array(
			'do'      => vB_Input::TYPE_STR,
			'days'    => vB_Input::TYPE_UINT,
			'ids'    => vB_Input::TYPE_STR,
			'count'    => vB_Input::TYPE_UINT,
			'forumchoice' => vB_Input::TYPE_ARRAY,
			'childforums' => vB_Input::TYPE_BOOL,
			'template_name'    => vB_Input::TYPE_STR,
			'detail_template' => vB_Input::TYPE_STR
		));

		$view = new vB_View_AJAXHTML('cms_widget_config');
		$view->title = new vB_Phrase('vbcms', 'configuring_widget_x', $this->widget->getTitle());
		$config = $this->widget->getConfig();

		if ((vB::$vbulletin->GPC['do'] == 'config') AND $this->verifyPostId())
		{
			if (vB::$vbulletin->GPC_exists['days'])
			{
				$config['days'] = vB::$vbulletin->GPC['days'];
			}

			if (vB::$vbulletin->GPC_exists['count'])
			{
				$config['count'] =  vB::$vbulletin->GPC['count'];
			}

			if (vB::$vbulletin->GPC_exists['template_name'])
			{
				$config['template_name'] = vB::$vbulletin->GPC['template_name'];
			}

			if (vB::$vbulletin->GPC_exists['detail_template'])
			{
				$config['detail_template'] = vB::$vbulletin->GPC['detail_template'];
			}

			if (vB::$vbulletin->GPC_exists['ids'])
			{
				$ids = explode(',', vB::$vbulletin->GPC['ids']);
				$cleaned = array();

				foreach ($ids as $id)
				{
					if (intval($id) AND (!in_array(intval($id))))
					{
						$cleaned[] = intval($id);
					}
				}

				$ids = implode(',', $cleaned);
				$config['ids'] = $ids ;
			}

			if (vB::$vbulletin->GPC_exists['forumchoice'])
			{
				$config['forumchoice'] =  vB::$vbulletin->GPC['forumchoice'];
			}

			$config['childforums'] =  vB::$vbulletin->GPC_exists['childforums'];


			$widgetdm = $this->widget->getDM();
			$widgetdm->set('config', $config);

			if ($this->content)
			{
				$widgetdm->setConfigNode($this->content->getNodeId());
			}

			$widgetdm->save();


			if (!$widgetdm->hasErrors())
			{
				if ($this->content)
				{
					$segments = array('node' => $this->content->getNodeURLSegment(),
										'action' => vB_Router::getUserAction('vBCms_Controller_Content', 'EditPage'));
					$view->setUrl(vB_View_AJAXHTML::URL_FINISHED, vBCms_Route_Content::getURL($segments));
				}

				$view->setStatus(vB_View_AJAXHTML::STATUS_FINISHED, new vB_Phrase('vbcms', 'configuration_saved'));
			}
			else
			{
				if (vB::$vbulletin->debug)
				{
					$view->addErrors($widgetdm->getErrors());
				}

				// only send a message
				$view->setStatus(vB_View_AJAXHTML::STATUS_MESSAGE, new vB_Phrase('vbcms', 'configuration_failed'));
			}
		}
		else
		{
			$configview = $this->createView('config');

			if (!isset($config['template_name']) OR ($config['template_name'] == '') )
			{
				$config['template_name'] = 'vbcms_widget_poll_page';
			}

			if (!isset($config['detail_template']) OR ($config['detail_template'] == '') )
			{
				$config['detail_template'] = 'vbcms_widget_poll_resultdetail';
			}
			// add the config content
			$configview->template_name = $config['template_name'];
			$configview->detail_template = $config['detail_template'];
			$configview->forumchoice_select = $this->getForums($config);
			$configview->childforumschecked = ($config['childforums'] ? 'checked="checked"' : '');
			$configview->count = $config['count'];
			$configview->days = $config['days'];
			$configview->ids = ((isset($config['ids']) AND is_array($config['ids']) AND count($config['ids']))
				? implode(',', $config['ids']) : '');

			// item id to ensure form is submitted to us
			$this->addPostId($configview);

			$view->setContent($configview);

			// send the view
			$view->setStatus(vB_View_AJAXHTML::STATUS_VIEW, new vB_Phrase('vbcms', 'configuring_widget'));
		}

		return $view;
	}


	/**
	 * Fetches the standard page view for a widget.
	 *
	 * @param bool $skip_errors					- If using a collection, omit widgets that throw errors
	 * @return vBCms_View_Widget				- The resolved view, or array of views
	 */
	public function getPageView()
	{
		include_once DIR . '/includes/functions_search.php';
		$this->assertWidget();
		$config = $this->widget->getConfig();

		// Create view

		if (isset($_REQUEST['nocache']) OR !$view = vB_Cache::instance()->read($this->getHash($this->widget->getId()), true))
		{
			$view = $this->makeResults($config);

			vB_Cache::instance()->write($this->getHash($this->widget->getId()),
				   $view, $this->cache_ttl);
		}

		$view->widget_title = $this->widget->getTitle();
		return $view;
	}


	/**
	 * This does the actual work of creating the navigation elements. This needs some
	 * styling, but we'll do that later.
	 * We use the existing search functionality. It's already all there, we just need
	 * to
	 *
	 * @return string;
	 */
	private function makeResults($config)
	{
		include_once DIR . '/includes/functions_misc.php';
		$search_core = vB_Search_Core::get_instance();

		$criteria = $search_core->create_criteria($search_core->get_search_type('vBForum',
			'Post'));
		$contenttypeid = $search_core->get_contenttypeid('vBForum',	'Post');
		$criteria->add_contenttype_filter($contenttypeid);
		$criteria->set_advanced_typeid($contenttypeid);


		if ($config['ids'])
		{
			$criteria->add_filter('threadid', vB_Search_Core::OP_EQ, $config['ids']);

		}
		else
		{
			if ($config['forumids'])
			{
				$criteria->add_forumid_filter($config['forumids'], $config['childforums']);
			}

			if ($config['days'])
			{
				$timelimit = TIMENOW - (86400 * $config['days']);
				$criteria->add_date_filter(vB_Search_Core::OP_GT, $timelimit);
			}

			vB::$vbulletin->GPC['pollidmin'] = 1;
			vB::$vbulletin->GPC_exists['pollidmin'] = true;
			$criteria->add_filter('pollid', vB_Search_Core::OP_GT, 0, true);

			$search_type = vB_Search_Core::get_instance()->get_search_type_from_id($contenttypeid);
			$search_type->add_advanced_search_filters($criteria, vB::$vbulletin);
			$criteria->set_grouped(vB_Search_Core::GROUP_YES);

		}

		if (! intval($config['count']))
		{
			$config['count'] = 5;
		}

		if (intval($config['count']) > 12)
		{
			$config['count'] = 5;
		}

		$criteria->set_sort('dateline', 'desc');
		$current_user = new vB_Legacy_CurrentUser();

		$results = vB_Search_Results::create_from_cache($current_user, $criteria);

		if (!$results)
		{
			$results = vB_Search_Results::create_from_criteria($current_user, $criteria);
		}
		return $this->renderResult($config, $results);
	}


	/**
	 * vBCms_Widget_Poll::getForums()
	 *
	 * @param mixed $config	- array of current configuration for this widget
	 * @return
	 */
	private function getForums($config, $name = 'forumchoice')
	{
		global $vbulletin, $vbphrase, $show;
		require_once DIR . '/includes/functions_search.php';

		//this will fill out $searchforumids as well as set the depth param in $vbulletin->forumcache
		global $searchforumids;
		fetch_search_forumids_array();


		$options = "";
		foreach ($searchforumids AS $forumid)
		{
			$forum = $vbulletin->forumcache["$forumid"];

			if (trim($forum['link']))
			{
				continue;
			}

			$optionvalue = $forumid;
			$optiontitle = "$forum[depthmark] $forum[title_clean]";

			if ($vbulletin->options['fulltextsearch'] AND
				!($vbulletin->userinfo['forumpermissions'][$forumid] & $vbulletin->bf_ugp_forumpermissions['canviewthreads']))
			{
				$optiontitle .= '*';
				$show['cantsearchposts'] = true;
			}

			$optionselected = '';

			if ($config['forumchoice'] AND in_array($forumid, $config['forumchoice']))
			{
				$optionselected = 'selected="selected"';
				$haveforum = true;
			}

			$options .= render_option_template($optiontitle, $forumid, $optionselected,
				'fjdpth' . min(4, $forum['depth']));
		}

		$select = "<select name=\"" .$name."[]\" multiple=\"multiple\" size=\"4\" $style_string>\n" .
					render_option_template($vbphrase['search_all_open_forums'], '',
						$haveforum ? '' : 'selected="selected"') .
					render_option_template($vbphrase['search_subscribed_forums'], 'subscribed') .
					$options .
				 	"</select>\r";
		return $select;

	}

	private function renderResult($config, $results)
	{
		$config = $this->widget->getConfig();

		if (!isset($config['template_name']) OR ($config['template_name'] == '') )
		{
			$config['template_name'] = 'vbcms_widget_poll_page';
		}
		if (!isset($config['detail_template']) OR ($config['detail_template'] == '') )
		{
			$config['detail_template'] = 'vbcms_widget_poll_resultdetail';
		}

		// Create view
		$view->class = $this->widget->getClass();
		$view->title = $this->widget->getTitle();
		$view->description = $this->widget->getDescription();

		$page = $results->get_page(1, $config['count'], 0);
		if (count($page))
		{
			$threads = array();
			foreach ($page as $result)
			{
				$threads[] = $result->get_thread()->get_field('threadid');
			}
			$where = implode(', ', $threads);
			if ($rst = vB::$vbulletin->db->query_read("SELECT p.question, p.options,
				p.votes, t.threadid FROM " . TABLE_PREFIX . "poll p INNER JOIN " . TABLE_PREFIX . "thread t
	 			ON t.pollid = p.pollid WHERE t.threadid IN ( " . $where . ");"))
			{
				$data = array();
				while ($row = vB::$vbulletin->db->fetch_array($rst))
				{
					$this_item = array();
					$options = explode('|||', $row['options'] );
					$votes = explode('|||', $row['votes'] );
					$detail = array();
					for ($i = 0; $i < count($options); $i++)
					{
						$detail[] = array('option' => $options[$i],
						'votes' => $votes[$i]);
					}
					$detailview = new vBCms_View_Widget($config['detail_template']);
					$detailview->resultdetail = $detail;
					$this_item['resultdetail'] = $detailview->render();
					$this_item['threadid'] = $row['threadid'];
					$this_item['question'] = $row['question'];
					$data[$row['threadid']] = $this_item;
				}

				if (!isset($config['template_name']) OR ($config['template_name'] == '') )
				{
					$config['template_name'] = 'vbcms_widget_poll_page';
				}
				$view = new vBCms_View_Widget($config['template_name']);
				$view->poll_data = $data;
				return $view;


			}
		}
	}
	/**
	 * Return the appropriate hash function. We include userid, because results
	 * will vary by user due to visibility/privilege variations.
	 *
	 * @param integer $widgetid
	 * @return hash that will identify this widget content for this user
	 */
	protected function getHash($widgetid)
	{
		$context = new vB_Context('widget' , array( 'widgetid' =>$widgetid,
		'group' => vB::$vbulletin->userinfo['usergroupid'],
		'groups' => vB::$vbulletin->userinfo['membergroupids']));
		return strval($context);

	}

}

/*======================================================================*\
|| ####################################################################

|| # SVN: $Revision: 32078 $
|| ####################################################################
\*======================================================================*/